﻿var simulator = {
    editor: null,
    list: null,
    currentSimulationId: 0,
    currentVariableId: 0,
    options: {
        name: "",
        numberOfCaseToGenerate: 0,
        maxNumberOfCaseToGenerate: 0,
        useNoDispositionSample: "False",
        disableBackwardBranching: "False"
    },
    dataTable: null,
    proportions: new Object(),
    surveyId: 0
}

$(document).ready(function () {
    simulator.editor = $(".v-simulationProportionEditor");

    if (simulator.editor.length > 0) {
        simulator.list = $(".v-variable-list", simulator.editor);
        simulator.ui = $(".v-simulation-ui-template", simulator.editor);
        simulator.options.maxNumberOfCaseToGenerate = parseInt($(".Simulation_MaxNumberOfGeneratedCase").html());
        simulator.currentSimulationId = $("#Id", simulator.editor).val();

        addSimulationEvent();

        $(".h-select-variable", simulator.list).first().trigger('click');
        //StartSimulationActivityWatcher();
    }
    else if ($(".h-simulations-table").length > 0) {
        initSimulationTable();

        $(".h-simulation-add", simulator.main).on("click", function () { modalDialog.showWindow(a4.getSurveyAction("Create", "Simulation"), 350, 700, { afterClose: function () { simulator.dataTable.a4datatable("refresh"); } }); });
    }
});

function initSimulationTable() {
    simulator.dataTable = $(".h-simulations-table", this.context).a4datatable({
        height: "full",
        ajaxAction: a4.getSurveyAction("GetSimulations", "Simulation"),
        columns: [
            { "Data": "LastExecutionMessage", "Tooltip": true },
            { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Width": "40px", "Key": true },
            { "Name": "Name", "Title": resources.SimulationName, "Data": "Name", "Class": "itemName" },
            { "Name": "State", "Title": resources.State, "Data": "State" },
            { "Name": "LastExecutionDateTime", "Title": resources.LastExecution, "Data": "LastExecutionDateTime", "Type": "date" },
            { "Name": "GeneratedRespondentCount", "Title": resources.GeneratedRespondentCount, "Data": "GeneratedRespondentCount" }
        ],
        localizableTexts: { "Search": resources.SearchSimulations },
        toolBarItems: [{ "Action": "delete", "Label": resources.Delete, "Visible": true }],
        autoUpdate: true,
        toolBarClick: function (event, data) {
            var rows = data.rows;
            var action = data.action;
            var ids = [];

            for (var i = 0; i < rows.length; i++) {
                ids.push(rows[i].Id);
            }

            switch (action) {
                case "delete":
                    deleteSimulations(ids);
                    break;
            }
        },
        contextMenuItems: [
            { "Action": "editProportions", "Label": resources.EditProportions },
            { "Divider": true },
            { "Action": "delete", "Label": resources.Delete },
            { "Action": "clear", "Label": resources.DeleteSimulatedData, "DisplayCondition": function (data) { return data.GeneratedRespondentCount > 0; } },
            { "Action": "edit", "Label": resources.Properties },
            { "Divider": true },
            { "Action": "run", "Label": resources.Run }
        ],
        contextMenuClick: function (event, data) {
            var row = data.row;
            var action = data.action;

            switch (action) {
                case "edit": editSimulation(row.Id); break;
                case "editProportions": editSimulationProportions(row.Id); break;
                case "run": runSimulation(row.Id); break;
                case "delete": deleteSimulation(row.Id); break;
                case "clear": clearSimulatedData(row.Id); break;
            }
        },
        rowCreated: function (event, data) {
        }
    });
}

function addSimulationEvent() {
    simulator.editor.on("click", ".h-select-variable", function () { selectVariableProportion($(this)); });
    simulator.editor.on("change", ".h-proportionEditor-change", function () { updateProportion($(this)); });
    simulator.editor.on("keydown", ".h-variables-filter", function (event) { if (event.which == 13) { event.preventDefault(); return false; } });
    simulator.editor.on("keyup", ".h-variables-filter", function (event) { return FilterVariables(event, $(this).val()); });
}

function ToggleExpand(header, content, setting) {
    $(content).toggle();
    $(".imgExpandSectionDarkClosed,.imgExpandSectionDarkOpen", header).toggleClass("imgExpandSectionDarkClosed imgExpandSectionDarkOpen");
    $(".imgHideSection,.imgDisplaySection", header).toggleClass("imgHideSection imgDisplaySection");
}

function selectVariableProportion(selectedVariable) {
    simulator.currentVariableId = parseInt($(selectedVariable).attr("data-id"));

    $(".h-select-variable", selectedVariable.parent()).removeClass("selected");
    selectedVariable.addClass("selected");

    $(".v-proportionEditor-section", simulator.editor).html(GetLoadingHTML());

    a4.callServerMethod(a4.getSurveyAction("RenderProportionsForVariable", "Simulation"), { simulationConfigurationId: simulator.currentSimulationId, variableId: simulator.currentVariableId },
            function (result) {

                var html = $(result);

                $(".h-autonumeric", html).autoNumeric({ aPad: false, vMin: '0', vMax: '100', mDec: '2', aSep: '' });

                if (simulator.proportions[simulator.currentVariableId]) {

                    var totalSection = $(".v-proportion-total", html);
                    var total = parseFloat(totalSection.html());

                    $.each(simulator.proportions[simulator.currentVariableId], function (index, value) {
                        var propField = $("input.h-proportionEditor-change[data-id=" + index + "]", html);
                        total = total - parseFloat($(propField).autoNumeric('get')) + value;

                        propField.val(value);
                        propField.attr({ "data-oldvalue": value });
                    });

                    totalSection.html(total);
                    updateTotalSectionDisplay(total, totalSection);
                }

                
                $(".v-proportionEditor-section", simulator.editor).html(html);
            },
		    function (error) {
		        ShowAjaxErrorMessage(error);
		    });
}

function runSimulation(simulationId) {
    a4.callServerMethod(a4.getSurveyAction("RunSimulation", "Simulation"), { simulationId: simulationId },
            function (result) {
                simulator.dataTable.a4datatable("refresh");
            },
		    function (error) { ShowAjaxErrorMessage(error); }
            );
}

function DisplaySimulationRunningLayer() {
    simulator.editor.show();
    simulator.editor.html($(".v-simulation-ui-runningtemplate").html());
}


function saveProportions() {

    $("#ProportionsJson", simulator.editor).val(JSON.stringify(simulator.proportions));

}

function updateProportion(proportionTextBox) {

    var probabilities = {};
    $(".v-proportions .v-proportions-choice .h-proportionEditor-change ", simulator.editor).map(
        function () {
            return probabilities[$(this).attr("data-id")] = parseFloat($(this).autoNumeric('get'));
        });

    simulator.proportions[simulator.currentVariableId] = probabilities;

    recalculateTotal(proportionTextBox);
}

function recalculateTotal(proportionTextBox) {
    var totalSection = $(".v-proportion-total", simulator.editor);
    var currentTotal = parseFloat(totalSection.html());

    var inputValue = parseFloat($(proportionTextBox).autoNumeric('get'));

    if (isNaN(inputValue)) {
        proportionTextBox.val(proportionTextBox.attr("data-oldvalue"));
    }
    else {
        var newTotal = currentTotal - parseFloat(proportionTextBox.attr("data-oldvalue")) + inputValue;

        totalSection.html(newTotal);
        proportionTextBox.attr({ "data-oldvalue": proportionTextBox.val() });

        updateTotalSectionDisplay(newTotal, totalSection);
    }
}

function updateTotalSectionDisplay(total, field) {
    if (total != 100) {
        field.addClass("invalid");
    } else {
        field.removeClass("invalid");
    }
}

function GetLoadingHTML() {
    return "<div class='informationSection'><div class='text'>" + resources.Loading + "<div><div>" + voxco.icons.getIcon("loading") + "</div><div>";
}

function editSimulation(simulationId) {
    modalDialog.showWindow(a4.getSurveyAction("Edit", "Simulation", { id: simulationId }), 350, 700, { afterClose: function () { simulator.dataTable.a4datatable("refresh"); } });
}

function editSimulationProportions(simulationId) {
    modalDialog.showWindow(a4.getSurveyAction("EditProportions", "Simulation", { id: simulationId }), 500, 780);
}

function deleteSimulation(simulationId) {
    modalDialog.showConfirmDialog(confirmDeleteSimulationResources, function (dialog) {
        a4.callServerMethod(a4.getSurveyAction("DeleteSimulation", "Simulation"), { simulationId: simulationId },
            function (result) {
                simulator.dataTable.a4datatable("refresh");
            },
            function (error) { ShowAjaxErrorMessage(error); });

    }, 250, 500, true);
}

function deleteSimulations(simulationIds) {
    modalDialog.showConfirmDialog(confirmDeleteSimulationResources, function (dialog) {
        a4.callServerMethod(a4.getSurveyAction("DeleteSimulations", "Simulation"), { simulationIds: simulationIds },
            function (result) {
                simulator.dataTable.a4datatable("refresh");
            },
            function (error) { ShowAjaxErrorMessage(error); });

    }, 250, 500, true);
}

function clearSimulatedData(simulationId) {
    modalDialog.showConfirmDialog(confirmClearSimulationResources, function () {
        a4.callServerMethod(a4.getSurveyAction("ClearSimulationRespondent", "Simulation"), { simulationId: simulationId },
            function (result) {
                simulator.dataTable.a4datatable("refresh");
            },
            function (error) { ShowAjaxErrorMessage(error); });
    }, 250, 500, true);
}

function StartSimulationActivityWatcher() {
    window.setTimeout(ExecuteSimulationActivityWatcher, 2000);
}

function FilterVariables(event, filterValue) {
    var variableList = $(".v-variable-list", simulator.editor);
    var regexpression = new RegExp(filterValue, "i");

    $(".h-select-variable", variableList).map(function () {
        if (regexpression.exec($(this).html())) {
            $(this).show();
        } else {
            $(this).hide();
        }
    });
}

function ShowAjaxErrorMessage(ajaxError) {
    var message = eval("(" + ajaxError.responseText + ")").Message;
    a4.showErrorMessage(message);
}